/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	GameStats
**
** DESCRIPTION:	Manages game statistics
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef GAMESTATS_H
#define GAMESTATS_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "../Puzzles/Puzzle.h"

#ifdef _MAC
#include "../HighScore/HighScore.h"
#endif

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CGameStats
{
public:

	//class structures
	struct SGameStats
	{
		unsigned int	m_uiGameStartTime;
		unsigned int	m_uiPointsEarned;
		int				m_iBabiesMade;
		unsigned int	m_uiFoodGathered;
		int				m_iVillagersCured;
		int				m_iItemsFound;
		int				m_iMaxPopulation;
		int				m_iVillagersDied;
		int				m_iOldestVillager;
		int				m_iNumCrisis;
		int				m_iNumTwins;
		int				m_iNumTriplets;

		unsigned int	m_uiCompletionTimes[ePuzzle_NumberOf];
	};

	struct SSaveState
	{
		SGameStats		m_sGameStats;
	};

private:

#ifdef _MAC
	bool m_bQueryInProgress;
	
	CHighScore mHighScore;
	
#endif

	//class data
	SGameStats			m_sGameStats;
	SGameStats			m_sGlobalRankings;

	//class methods
	//setup
	public:		CGameStats(void);
	public:		void Reset();
	public:		const bool LoadState(SSaveState &sSaveState);
	public:		const bool SaveState(SSaveState &sSaveState);
	
	// process
	
#ifndef _MAC
	public:		const bool Refresh();
#else
	public:		bool StartRefresh();
	public:     bool RefreshCompleted();
	public:     bool RefreshSuccessful(); 
	public:		void CancelRefresh();
#endif
	// access
	public:		void SetGameStartTime(const unsigned int uiGameStartTime) { m_sGameStats.m_uiGameStartTime = uiGameStartTime; }
	public:		void IncrementPoints(const unsigned int uiPoints = 1) { m_sGameStats.m_uiPointsEarned += uiPoints; }
	public:		void IncrementBabiesMade(const int iBabiesMade = 1) { m_sGameStats.m_iBabiesMade += iBabiesMade; }
	public:		void IncrementFoodGathered(const unsigned int uiFoodGathered = 1) { m_sGameStats.m_uiFoodGathered += uiFoodGathered; }
	public:		void IncrementVillagersCured(const int iVillagersCured = 1) { m_sGameStats.m_iVillagersCured += iVillagersCured; }
	public:		void IncrementItemsFound(const int iItemsFound = 1) { m_sGameStats.m_iItemsFound += iItemsFound; }
	public:		void SetMaxPopulation(const int iMaxPopulation) { m_sGameStats.m_iMaxPopulation = iMaxPopulation; }
	public:		void IncrementVillagersDied(const int iVillagersDied = 1) { m_sGameStats.m_iVillagersDied += iVillagersDied; }
	public:		void SetOldestVillager(const int iOldestVillager) { m_sGameStats.m_iOldestVillager = iOldestVillager; }
	public:		void IncrementCrisis(const int iCrisis = 1) { m_sGameStats.m_iNumCrisis += iCrisis; }
	public:		void IncrementTwins(const int iTwins = 1) { m_sGameStats.m_iNumTwins += iTwins; }
	public:		void IncrementTriplets(const int iTriplets = 1) { m_sGameStats.m_iNumTriplets += iTriplets; }

	public:		const unsigned int GameStartTime() const { return m_sGameStats.m_uiGameStartTime; }
	public:		const unsigned int GetPointsEarned() const {return m_sGameStats.m_uiPointsEarned;}
	public:		const int VillagersCured() const { return m_sGameStats.m_iVillagersCured; }
	public:		const int ItemsFound() const { return m_sGameStats.m_iItemsFound; }
	public:		const int MaxPopulation() const { return m_sGameStats.m_iMaxPopulation; }
	public:		const int OldestVillager() const { return m_sGameStats.m_iOldestVillager; }
	public:		const int Crisis() const { return m_sGameStats.m_iNumCrisis; }

	public:		const SGameStats &GameStats() const { return m_sGameStats; }
	public:		const SGameStats &GlobalRankings() const { return m_sGlobalRankings; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CGameStats		GameStats;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/